@extends('front.layouts.master')
@section('content')


  <div class="slider-area ">
        <div class="single-slider hero-overly slider-height2 d-flex align-items-center" data-background="{{ asset('front_assets/assets/img/hero/about.jpg') }}">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="hero-cap pt-100">
                            <h2> Blog</h2>
                            <nav aria-label="breadcrumb ">
                                <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                                <li class="breadcrumb-item"><a href="#"> Blog</a></li> 
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>






<!-- slider Area End-->
    <!--================Blog Area =================-->
    <section class="blog_area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mb-5 mb-lg-0">
                    <div class="blog_left_sidebar">

                           
                      
                            
@if($tags->count() > 0)
                @foreach($tags as $tag)                    
                        <article class="blog_item">
                            <div class="blog_item_img">
                                <img class="card-img rounded-0" src="/storage/{{ $tag->image }}" alt="">
                                <a href="#" class="blog_item_date">
                                    <h3>{{ $tag->updated_at->diffForHumans()  }}</h3>
                                  
                                </a>
                            </div>

                            <div class="blog_details">
                                <a class="d-inline-block" href="{{ route('blog.detail',$tag->slug) }}">
                                    <h2>{{ $tag->heading }}</h2>
                                </a>
                                <p>{{ $tag->short_description }}</p>
                                <ul class="blog-info-link">
    <li><a href="#"><i class="fa fa-user"></i>Published by:{{ $tag->published_by }}</a></li>


                                    <li><a href="#"><i class="fa fa-comments"></i> 03 Comments</a></li>
                                </ul>
                            </div>
                        </article>
                                     @endforeach

                                     {{ $tags->appends(['search' => request()->query('search')]) ->links() }}    
 @else

 <div class="alert alert-primary alert-dismissible fade show" role="alert">
  <strong>Oops!! sorry your {{  $tag_blog->name  }} </strong> Tag donot contain blog  
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>


 @endif
                     
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="blog_right_sidebar">

                        <aside class="single_sidebar_widget search_widget">
                            <form action="{{ url('/search') }}" method="GET">
                                <div class="form-group">
                                    <div class="input-group mb-3">
                                        <input type="text" class="form-control" placeholder='Search Keyword'
                                            onfocus="this.placeholder = ''"
                                            onblur="this.placeholder = 'Search Keyword'" name="search">
                                        <div class="input-group-append">
                                            <button class="btns" type="submit"><i class="ti-search"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <button class="button rounded-0 primary-bg text-white w-100 btn_1 boxed-btn"
                                    type="submit">Search</button>
                            </form>
                        </aside>

                        @php

$categories=App\Models\Category::all();

@endphp
                        <aside class="single_sidebar_widget post_category_widget">
                            <h4 class="widget_title">Category</h4>
                            <ul class="list cat-list">
                            @foreach($categories as $category)
                                <li>
                                    <a href="{{ route('category.slug',$category->id) }}" class="d-flex">
                                        <p>{{ $category->name }}</p>
                                        <p>({{ $category->blogs()->count() }})</p>
                                    </a>
                                </li>
                                @endforeach
                               

                            </ul>
                        </aside>

                        @php
                        $tags=App\Models\Tag::all();

     $popular_blogs=App\Models\Blog::where('blog_type','popular')->where([['status',1]])->OrderBy('weight','asc')->take(4)->get();
        @endphp

                        <aside class="single_sidebar_widget popular_post_widget">
                            <h3 class="widget_title">Recent Post</h3>

                            @foreach($popular_blogs as $popular_blog)
                            <div class="media post_item">
 <a href="{{ route('blog.detail',$popular_blog->slug) }}">  <img src="/storage/{{ $popular_blog->image }}" alt="post" height="50px" width="50px"></a>
                                <div class="media-body">
                                <a href="{{ route('blog.detail',$popular_blog->slug) }}">
                                        <h3>{{ $popular_blog->heading }}</h3></a>
                                   
                                    <p>{{ $popular_blog->created_at }}</p> </a>
                                </div>
                            </div>
                            @endforeach
                           


                        </aside>

                        <aside class="single_sidebar_widget tag_cloud_widget">
                            <h4 class="widget_title">Tag</h4>
                            <ul class="list">

                            @foreach($tags as $tag)
                                <li>
                                    <a href="{{ route('tags.group',$tag->id) }}">{{ $tag->name }}</a>
                                </li>
                                @endforeach

                            </ul>
                        </aside>


                       

                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection